<?php

namespace lhp;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Temuan extends Model 
{

    protected $table = 'temuan';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('temuan_isi', 'temuan_analisis', 'temuan_kesimpulan', 'temuan_saran');
    protected $visible = array('temuan_isi', 'temuan_analisis', 'temuan_kesimpulan', 'temuan_saran');

    public function getAnalisis()
    {
        return $this->hasOne('lhp\Analisis', 'analisis_id');
    }

    public function getKesimpulan()
    {
        return $this->hasOne('lhp\Kesimpulan', 'kesimpulan_id');
    }

    public function getObjekPemeriksaan()
    {
        return $this->hasOne('lhp\ObjekPemeriksaan', 'object_pemeriksaan_id');
    }

    public function getSaran()
    {
        return $this->hasOne('lhp\Saran', 'saran_id');
    }

}