<?php

namespace upt;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pengawas extends Model 
{

    protected $table = 'pengawas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('pengawas_upt', 'pengawas_nip', 'pengawas_jabatan');
    protected $visible = array('pengawas_upt', 'pengawas_nip', 'pengawas_jabatan');

    public function getUpt()
    {
        return $this->hasOne('upt\Upt', 'pengawas_upt');
    }

}