<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuizUser extends Model 
{

    protected $table = 'quiz_user';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function quiz()
    {
        return $this->hasOne('Quiz');
    }

    public function user()
    {
        return $this->hasOne('User');
    }

    public function userQuentionAnswers()
    {
        return $this->hasMany('UserQuestionAnswer');
    }

}