<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('menu_items', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_menu_item', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_menu_item', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('menu_items', function(Blueprint $table) {
			$table->dropForeign('menu_items_category_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('order_menu_item', function(Blueprint $table) {
			$table->dropForeign('order_menu_item_menu_item_id_foreign');
		});
		Schema::table('order_menu_item', function(Blueprint $table) {
			$table->dropForeign('order_menu_item_order_id_foreign');
		});
	}
}