<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionnairesTable extends Migration {

	public function up()
	{
		Schema::create('questionnaires', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('evenement_id')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('logement', 10)->nullable()->default('0');
			$table->string('nom', 255)->nullable();
			$table->string('score', 10)->nullable()->default('0');
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('questionnaires');
	}
}