<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('admins_evenements', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('admins_evenements', function(Blueprint $table) {
			$table->foreign('global_admin_id')->references('id')->on('globals_admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('invite_id')->references('id')->on('invites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('ceremonie_id')->references('id')->on('ceremonies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('temoignages', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('temoignages', function(Blueprint $table) {
			$table->foreign('invite_id')->references('id')->on('invites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('ceremonie_id')->references('id')->on('ceremonies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('questionnaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reponses_questions', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites_reponses_questions', function(Blueprint $table) {
			$table->foreign('invite_id')->references('id')->on('invites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites_reponses_questions', function(Blueprint $table) {
			$table->foreign('reponse_question_id')->references('id')->on('reponses_questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ceremonies', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('positions_photos', function(Blueprint $table) {
			$table->foreign('photo_id')->references('id')->on('photos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('positions_photos', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('positions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories_photos', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories_photos', function(Blueprint $table) {
			$table->foreign('photo_id')->references('id')->on('photos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cadeaux', function(Blueprint $table) {
			$table->foreign('invite_id')->references('id')->on('invites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('configs', function(Blueprint $table) {
			$table->foreign('global_admin_id')->references('id')->on('globals_admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('versements', function(Blueprint $table) {
			$table->foreign('evenement_id')->references('id')->on('evenements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invite_ceremonie', function(Blueprint $table) {
			$table->foreign('invite_id')->references('id')->on('invites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invite_ceremonie', function(Blueprint $table) {
			$table->foreign('ceremonie_id')->references('id')->on('ceremonies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites_tables', function(Blueprint $table) {
			$table->foreign('invite_id')->references('id')->on('invites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invites_tables', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('admins_evenements', function(Blueprint $table) {
			$table->dropForeign('admins_evenements_evenement_id_foreign');
		});
		Schema::table('admins_evenements', function(Blueprint $table) {
			$table->dropForeign('admins_evenements_global_admin_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_evenement_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_table_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_invite_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_ceremonie_id_foreign');
		});
		Schema::table('temoignages', function(Blueprint $table) {
			$table->dropForeign('temoignages_evenement_id_foreign');
		});
		Schema::table('temoignages', function(Blueprint $table) {
			$table->dropForeign('temoignages_invite_id_foreign');
		});
		Schema::table('photos', function(Blueprint $table) {
			$table->dropForeign('photos_evenement_id_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_ceremonie_id_foreign');
		});
		Schema::table('questionnaires', function(Blueprint $table) {
			$table->dropForeign('questionnaires_evenement_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_questionnaire_id_foreign');
		});
		Schema::table('reponses_questions', function(Blueprint $table) {
			$table->dropForeign('reponses_questions_question_id_foreign');
		});
		Schema::table('invites_reponses_questions', function(Blueprint $table) {
			$table->dropForeign('invites_reponses_questions_invite_id_foreign');
		});
		Schema::table('invites_reponses_questions', function(Blueprint $table) {
			$table->dropForeign('invites_reponses_questions_reponse_question_id_foreign');
		});
		Schema::table('ceremonies', function(Blueprint $table) {
			$table->dropForeign('ceremonies_evenement_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_evenement_id_foreign');
		});
		Schema::table('positions_photos', function(Blueprint $table) {
			$table->dropForeign('positions_photos_photo_id_foreign');
		});
		Schema::table('positions_photos', function(Blueprint $table) {
			$table->dropForeign('positions_photos_position_id_foreign');
		});
		Schema::table('categories_photos', function(Blueprint $table) {
			$table->dropForeign('categories_photos_categorie_id_foreign');
		});
		Schema::table('categories_photos', function(Blueprint $table) {
			$table->dropForeign('categories_photos_photo_id_foreign');
		});
		Schema::table('cadeaux', function(Blueprint $table) {
			$table->dropForeign('cadeaux_invite_id_foreign');
		});
		Schema::table('configs', function(Blueprint $table) {
			$table->dropForeign('configs_global_admin_id_foreign');
		});
		Schema::table('versements', function(Blueprint $table) {
			$table->dropForeign('versements_evenement_id_foreign');
		});
		Schema::table('invite_ceremonie', function(Blueprint $table) {
			$table->dropForeign('invite_ceremonie_invite_id_foreign');
		});
		Schema::table('invite_ceremonie', function(Blueprint $table) {
			$table->dropForeign('invite_ceremonie_ceremonie_id_foreign');
		});
		Schema::table('invites_tables', function(Blueprint $table) {
			$table->dropForeign('invites_tables_invite_id_foreign');
		});
		Schema::table('invites_tables', function(Blueprint $table) {
			$table->dropForeign('invites_tables_table_id_foreign');
		});
	}
}