<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id', 'name', 'email', 'password');
    protected $visible = array('id', 'name', 'email');

    public function getPosts()
    {
        return $this->hasMany('App\Posts', 'posted_by');
    }

    public function getNews()
    {
        return $this->hasMany('App\News', 'posted_by');
    }

    public function getEvents()
    {
        return $this->hasMany('App\Events', 'posted_by');
    }

    public function getFriends()
    {
        return $this->hasMany('App\Relationship', 'user_id');
    }

}