<?php

namespace App;

class PostsComment extends Eloquent {

	protected $table = 'posts_comments';
	public $timestamps = true;
	protected $fillable = array('post_id', 'posted_by', 'commented_by', 'comment');
	protected $visible = array('post_id', 'posted_by', 'commented_by', 'comment');

	public function post()
	{
		return $this->belongsTo('App\Posts', 'post_id');
	}

	public function postedBy()
	{
		return $this->belongsTo('App\User', 'posted_by');
	}

	public function commentedBy()
	{
		return $this->belongsTo('App\User', 'commented_by');
	}

}