<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdrecCategoryTable extends Migration {

	public function up()
	{
		Schema::create('adrec_category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable()->index();
			$table->string('description', 255)->nullable()->index();
			$table->integer('user_id')->index();
			$table->string('company_id', 255)->index();
		});
	}

	public function down()
	{
		Schema::drop('adrec_category');
	}
}