<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdrecDeliveryConceptTable extends Migration {

	public function up()
	{
		Schema::create('adrec_delivery_concept', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable()->index();
			$table->json('owner')->nullable()->index();
			$table->json('creator')->nullable()->index();
			$table->json('company')->nullable()->index();
			$table->json('category')->nullable()->index();
			$table->json('brand')->nullable()->index();
			$table->json('product')->nullable()->index();
			$table->json('creative')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('adrec_delivery_concept');
	}
}