<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdrecCreativeTable extends Migration {

	public function up()
	{
		Schema::create('adrec_creative', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->index();
			$table->string('brief', 5000)->nullable()->index();
			$table->json('material')->nullable()->index();
			$table->json('category')->nullable()->index();
			$table->json('brand')->nullable()->index();
			$table->json('product')->nullable()->index();
			$table->integer('delivery_time')->nullable()->index();
			$table->json('delivery')->nullable()->index();
			$table->string('status')->nullable()->index();
			$table->json('owner')->nullable()->index();
			$table->json('creator')->nullable()->index();
			$table->json('pic')->nullable()->index();
			$table->json('campaign')->nullable()->index();
			$table->json('company')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('adrec_creative');
	}
}