<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnrollmentsTable extends Migration {

	public function up()
	{
		Schema::create('enrollments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('training_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('payment_id')->unsigned();
			$table->string('enrollment_key', 255);
		});
	}

	public function down()
	{
		Schema::drop('enrollments');
	}
}