<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsSectionTable extends Migration {

	public function up()
	{
		Schema::create('lessons_section', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 199);
			$table->string('video', 255);
			$table->text('paragraph');
			$table->integer('lesson_id')->unsigned();
			$table->integer('lessons_section_number')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('lessons_section');
	}
}