<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Conversation extends Eloquent {

	protected $table = 'conversations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function author()
	{
		return $this->belongsTo('Training', 'author_id');
	}

	public function message()
	{
		return $this->hasMany('Message', 'conversation_id');
	}

}