<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ECertificate extends Eloquent {

	protected $table = 'e_certificates';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('file_name');

	public function training()
	{
		return $this->belongsTo('Training', 'training_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

}