<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EnrolledTraining extends Eloquent {

	protected $table = 'enrolled_training';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id');

	public function training_schedule()
	{
		return $this->belongsTo('TrainingSchedule', 'schedule_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

}