<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lesson extends Eloquent {

	protected $table = 'lessons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'description', 'lesson_number');

	public function training()
	{
		return $this->belongsTo('Training', 'training_id');
	}

	public function supporting_material()
	{
		return $this->hasMany('SupportingMaterials', 'lesson_id');
	}

	public function lessons_section()
	{
		return $this->hasMany('LessonSection', 'lesson_id');
	}

}