<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LessonSection extends Eloquent {

	protected $table = 'lessons_section';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'video', 'paragraph', 'lessons_section_number');

	public function lesson()
	{
		return $this->belongsTo('Lesson');
	}

}