<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('message');

	public function conversation()
	{
		return $this->belongsTo('Conversation', 'conversation_id');
	}

}