<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('status', 'payment_time');

	public function enrollment()
	{
		return $this->hasMany('Enrollment', 'payment_id');
	}

	public function training()
	{
		return $this->belongsTo('Training', 'training_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

}