<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Review extends Eloquent {

	protected $table = 'reviews';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('rating', 'review_text');

	public function training()
	{
		return $this->belongsTo('Training', 'training_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

}