<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Training extends Eloquent {

	protected $table = 'trainings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'preview', 'description', 'location', 'overall_rating', 'price', 'is_online');

	public function training_schedule()
	{
		return $this->hasMany('TrainingSchedule');
	}

	public function lessons()
	{
		return $this->hasMany('Lesson', 'training_id');
	}

	public function payment()
	{
		return $this->hasMany('Payment', 'training_id');
	}

	public function enrollment()
	{
		return $this->hasMany('Enrollment', 'training_id');
	}

	public function ecertificate()
	{
		return $this->hasMany('ECertificate', 'training_id');
	}

	public function review()
	{
		return $this->hasMany('Training', 'training_id');
	}

	public function enrolled_training()
	{
		return $this->hasMany('EnrolledTraining', 'training_id');
	}

	public function pre_test()
	{
		return $this->hasMany('PreTest', 'training_id');
	}

	public function post_test()
	{
		return $this->hasMany('PostTest', 'training_id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'creator_id');
	}

}