<?php

namespace Api;

class Transaction extends Eloquent {

	protected $table = 'transaction';
	public $timestamps = true;
	protected $fillable = array('amount', 'client_id', 'container_id', 'account_id', 'currency', 'balance_before', 'balance_after');

	public function Client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function Container()
	{
		return $this->belongsTo('Container', 'container_id');
	}

	public function Account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

}