<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name', 100);
			$table->string('email', 100);
			$table->string('mobile', 100);
			$table->date('dob');
			$table->string('location', 100)->nullable();
			$table->integer('status');
			$table->integer('otp');
			$table->string('gender', 10);
			$table->string('nationality', 10);
			$table->text('language');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}