<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsAndEventsTable extends Migration {

	public function up()
	{
		Schema::create('news_and_events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 100)->nullable();
			$table->string('image', 100)->nullable();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('news_and_events');
	}
}