<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ad extends Model 
{

    protected $table = 'ads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function city()
    {
        return $this->belongsTo('City');
    }

    public function package()
    {
        return $this->hasOne('Package');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function screen()
    {
        return $this->belongsTo('Screen');
    }

    public function marketer()
    {
        return $this->belongsTo('Marketer');
    }

}