<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateScreensTable extends Migration {

	public function up()
	{
		Schema::create('screens', function(Blueprint $table) {
			$table->increments('id');
			$table->string('dimension');
			$table->double('stock');
			$table->bigInteger('company_id')->nullable();
			$table->bigInteger('category_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('screens');
	}
}