<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePodcastsTable extends Migration {

	public function up()
	{
		Schema::create('podcasts', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->softDeletes();
			$table->string('name');
			$table->text('description');
			$table->string('author');
			$table->string('feed_url');
			$table->enum('type', array('library', 'on-demand', 'custom'));
			$table->timestamps();
			$table->boolean('updatable')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('podcasts');
	}
}