<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuizOptionsTable extends Migration {

	public function up()
	{
		Schema::create('quiz_options', function(Blueprint $table) {
			$table->increments('id');
			$table->string('value');
			$table->integer('question_id')->unsigned();
			$table->integer('order')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid');
		});
	}

	public function down()
	{
		Schema::drop('quiz_options');
	}
}