<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePageSubcategoriesTable extends Migration {

	public function up()
	{
		Schema::create('page_subcategories', function(Blueprint $table) {
			$table->string('page_subcategorie_id')->unique()->primary();
			$table->string('page_subcategorie_description');
			$table->string('hashtage')->nullable();
			$table->string('page_cover_image')->nullable();
			$table->boolean('has_multiple_page')->default(0);
			$table->boolean('has_video')->default(0);
			$table->boolean('has_emty_page')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('page_subcategories');
	}
}