<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->string('page_id')->unique()->primary();
			$table->string('position')->nullable();
			$table->string('page_name');
			$table->string('page_content')->nullable();
			$table->string('page_images');
			$table->string('page_menu_icon');
			$table->string('page_categorie_id');
			$table->string('page_subcategorie_id');
			$table->string('page_video_url');
			$table->boolean('is_active')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}