<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EstadoLiquidacion extends Eloquent {

	protected $table = 'estado_liquidaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');
	protected $visible = array('name');

	public function liquidaciones()
	{
		return $this->hasMany('EstadoLiquidacionLiquidacion', 'estado_liquidacion_id');
	}

}