<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Modulo extends Eloquent {

	protected $table = 'modulos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'route');
	protected $visible = array('name', 'route');

	public function tipo_solicitudes()
	{
		return $this->hasMany('App\Models\TipoSolicitud', 'modulo_id');
	}

}