<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TipoDistribuidora extends Eloquent {

	protected $table = 'tipo_distribuidoras';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('code', 'name');
	protected $visible = array('code', 'name');

	public function distribuidoras()
	{
		return $this->hasMany('Distribuidora', 'tipo_distribuidora_id')->withTrashed();
	}

}