<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShopsTable extends Migration {

	public function up()
	{
		Schema::create('shops', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_user')->unsigned();
			$table->string('name');
			$table->integer('id_category')->unsigned();
			$table->string('status');
			$table->datetime('actived_at')->nullable();
			$table->datetime('disabled_at');
			$table->string('banner')->nullable();
			$table->text('description')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('shops');
	}
}