<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('car_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('name', 255);
			$table->string('make_model', 255);
			$table->integer('make_year');
			$table->integer('price');
			$table->integer('rating');
			$table->boolean('status')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}