<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->double('price')->nullable();
			$table->text('notes')->nullable();
			$table->double('paid')->nullable();
			$table->double('remain')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}