<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ContentHistory extends Eloquent {

	protected $table = 'content_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('content_id', 'user_id', 'date', 'details');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function content()
	{
		return $this->belongsTo('ShippingContent', 'content_id');
	}

}