<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Fund extends Eloquent {

	protected $table = 'fund';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('number', 'country_id', 'user_id', 'currency_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function currency()
	{
		return $this->belongsTo('Currency', 'currency_id');
	}

}