<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InvoicePayment extends Eloquent {

	protected $table = 'invoice_payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fund_id', 'amount', 'paid_at', 'note', 'invoice_id', 'user_id');

	public function fund()
	{
		return $this->belongsTo('Fund', 'fund_id');
	}

	public function invoice()
	{
		return $this->belongsTo('Invoice', 'invoice_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}