<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Receipt extends Eloquent {

	protected $table = 'receipt';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_type', 'receipt_type', 'amount', 'currency_id', 'fund_id', 'details', 'client_id', 'type_id', 'user_id');

	public function currency()
	{
		return $this->belongsTo('Currency', 'currency_id');
	}

	public function fund()
	{
		return $this->belongsTo('Fund', 'fund_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function type()
	{
		return $this->belongsTo('Type', 'type_id');
	}

}