<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'mark', 'email', 'account_number', 'company_name', 'phone', 'mobile', 'fax', 'country_id', 'city_id', 'address', 'bank_name', 'swift_code', 'account_name', 'iban', 'branch', 'passport', 'user_id', 'status', 'shipping_cost', 'total_amount');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function currency()
    {
        return $this->belongsTo('Currency', 'currency_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function contents()
    {
        return $this->belongsTo('ShippingContent', 'client_id');
    }

}