<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoice';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'client_id', 'price', 'notes', 'paid', 'remain');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function items()
    {
        return $this->hasMany('InvoiceItems', 'invoice_id');
    }

    public function payments()
    {
        return $this->hasMany('InvoicePayment', 'invoice_id');
    }

}