<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuotationItems extends Model 
{

    protected $table = 'quotation_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'quantity', 'price', 'shipping_price', 'quotation_id', 'description');

    public function quotation()
    {
        return $this->belongsTo('Quotation', 'quotation_id');
    }

}