<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shipping extends Model 
{

    protected $table = 'shipping';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('number', 'container_type_id', 'transport_company_id', 'from_port_id', 'to_port_id', 'who_use', 'date', 'status', 'expense_total', 'total', 'revenue', 'user_id', 'total_shipping', 'arrival_date');

    public function clients()
    {
        return $this->belongsToMany('Client', 'shipping_client', 'shipping_id', 'client_id');
    }

    public function contents()
    {
        return $this->hasMany('ShippingContent', 'shipping_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function fund()
    {
        return $this->belongsTo('Fund', 'fund_id');
    }

    public function transport_company()
    {
        return $this->belongsTo('TransportCompany', 'transport_company_id');
    }

    public function from_port()
    {
        return $this->belongsTo('Port', 'from_port_id');
    }

    public function to_port()
    {
        return $this->belongsTo('Port', 'to_port_id');
    }

    public function type()
    {
        return $this->belongsTo('ContainerType', 'container_type_id');
    }

}