<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('mark')->nullable();
			$table->string('email')->nullable();
			$table->string('account_number')->nullable();
			$table->string('company_name')->nullable();
			$table->string('phone')->nullable();
			$table->string('mobile')->nullable();
			$table->string('fax')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->string('address')->nullable();
			$table->string('bank_name')->nullable();
			$table->string('swift_code')->nullable();
			$table->string('account_name')->nullable();
			$table->string('iban')->nullable();
			$table->string('branch')->nullable();
			$table->string('passport')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('status')->nullable();
			$table->double('shipping_cost')->nullable();
			$table->double('total_amount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}