<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReceiptTable extends Migration {

	public function up()
	{
		Schema::create('receipt', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('account_type')->nullable();
			$table->string('receipt_type')->nullable();
			$table->double('amount')->nullable();
			$table->integer('currency_id')->nullable();
			$table->integer('fund_id')->nullable();
			$table->text('details')->nullable();
			$table->integer('client_id')->nullable();
			$table->integer('type_id')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('receipt');
	}
}