<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingTable extends Migration {

	public function up()
	{
		Schema::create('shipping', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('number')->nullable();
			$table->integer('container_type_id')->nullable();
			$table->integer('transport_company_id')->nullable();
			$table->integer('from_port_id')->nullable();
			$table->integer('to_port_id')->nullable();
			$table->string('who_use')->nullable();
			$table->string('date')->nullable();
			$table->string('status')->nullable();
			$table->double('expense_total')->nullable();
			$table->double('total')->nullable();
			$table->double('revenue')->nullable();
			$table->integer('user_id')->nullable();
			$table->double('total_shipping')->nullable();
			$table->datetime('arrival_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping');
	}
}