<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('phone_number');
			$table->enum('gender', array('Male', 'Female'));
			$table->string('image');
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}