<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices_details', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices_details', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_customer_id_foreign');
		});
		Schema::table('invoices_details', function(Blueprint $table) {
			$table->dropForeign('invoices_details_invoice_id_foreign');
		});
		Schema::table('invoices_details', function(Blueprint $table) {
			$table->dropForeign('invoices_details_product_id_foreign');
		});
	}
}